#include<iostream>
#include<conio.h>
#include<math.h>
#include<ctime>
#include<time.h>
#include<winsock.h>

using namespace std;
#define PATH "C:/ReadMe.txt"
#define PATHPA "C:/RiskArray.txt"
#define PATHPort "C:/Portfolio.txt"
#define PATHRAr "C:/ParameterFile.txt"
#define PATHTDT "C:/TierDivisionTable.txt"
#define PATHTST "C:/TierSpreadTable.txt"
#define PATHDST "C:/DeltaSpreadTable.txt"
#define PATHSPT "C:/SpreadPrioTable.txt"
#define PATHOC "C:/OutrightCharge.txt"
#define PATHRatio "C:/Ratio.txt"
#define PATHInterRate "C:/InterCharge.txt"
//ASSUMPTIONS
#define Spread_Charge 25	//defining charges acc to table 1.13 of KTH thesis paper
#define Outright_Charge 50
#define CuNetPos -15
#define CuWFPR 70
#define Credit 0.4

void main()
{
	FILE * readPort, *readRAr, *readPA, *readTDT, *readTST, *readDST, *readSPT, *readOC, *readRatio, *readInterRate;
	int netposdel = 0, DMC = 0;
	SYSTEMTIME start, end, diff;
	readRAr = NULL;
	readPort = NULL;
	readPA = NULL;
	int pos, mat, price, th, vol, quantile, psr, volsr, intRate, VC[16], W[16];
	float PSR, posLoss[16], PC[16], Long[12], Short[12];
	char asset[20];
	GetSystemTime(&start);
	fopen_s(&readPort, PATHPort, "r");	//Reading Portfolio data
	fopen_s(&readPA, PATHPA, "r");	//Reading Parameter Array
	fopen_s(&readRAr, PATHRAr, "r");	//Reading Risk Array data
	fopen_s(&readTDT, PATHTDT, "r");	//Reading Tier Division table
	fopen_s(&readTST, PATHTST, "r");	//Reading Tier Spread table data
	fopen_s(&readDST, PATHDST, "r");	//Reading Delta spread table data
	fopen_s(&readSPT, PATHSPT, "r");	//Reading Spread Priority table data
	fopen_s(&readOC, PATHOC, "r");		//Reading Outright charge data
	//related to outright chare for cross-commodity
	fopen_s(&readRatio, PATHRatio, "r"); //reaing Rato for differnt commodity - cross commodity
	fopen_s(&readInterRate, PATHInterRate, "r");	//related to inter charge or weightage for cross-commodity

	for (int i = 0; i < 16; i++)
	{
		posLoss[i] = 0;
		Long[i] = 0;
		Short[i] = 0;
	}		//initialising posLoss Array


	if ((readPort != NULL) && (readRAr != NULL) && (readPA != NULL))	//Read if Portfolio file opened
	{
		fscanf_s(readPort, "%d\t%d\t%d", &pos, &mat, &price);	//read 1st line of portfolio file
		fscanf_s(readRAr, "%d %d %d %d %d %d\n", &vol, &th, &quantile, &psr, &volsr, &intRate);	//read First line of Parameter file
		PSR = price * (vol/100.0) * (sqrt(float(th) / 252.0)) * quantile;	//PSR(Price Scan Range) calculated each time Portfolio file is read
		for (int i = 0; i < 16; i++)
		{
			if (readPA)
				fscanf_s(readPA, "%f\t%d\t%d\n", &PC[i], &VC[i], &W[i]);
			else
				std::cout << "Invalid number of entires in Risk Parameter File" << endl;

				posLoss[i] += (PC[i] * float(W[i] / 100.0) * PSR) * pos;	//Position loss for each row of Risk array
		}

		int month = (mat / 31), DMSC = 0, DMOC = 0;	//month charge declarations
		netposdel += pos;
		if (pos < 0)
		{
			Short[month] += pos;
		}
		else
		{
			Long[month] += pos;
		}

		int j = 1, maxMonth = month; //j meant for index of mat and pos, maxMotnth stores the max month reached
		while(!feof(readPort))
		{
			fscanf_s(readPort, "%d\t%d\t%d\n", &pos, &mat, &price);
			j++;
			netposdel += pos;
			month = mat / 31;	//get month value after each reada of mat
			PSR = price * (vol / 100.0) * (sqrt(float(th) / 252.0)) * quantile;
			for (int i = 0; i < 16; i++)
			{
				posLoss[i] += (PC[i] * (W[i] / 100) * PSR) * pos;	//Calculating position loss
			}
			//making Long and Short arrays 
			if(pos < 0)
			{Short[month] += pos; }
			else
			{Long[month] += pos; }
			maxMonth = (month > maxMonth) ? month : maxMonth;
			if (Long[month] > -(Short[month]))	//as soon as a long and short exist for the same month, make short 0 if possible
			{
				Long[month] += Short[month];
				DMSC += Short[month] * Spread_Charge;	//add to DMSC everytime there is a non zero short
				Short[month] = 0;
			}
			else
			{
				Long[month] = 0;
				DMSC += -(Long[month] * Spread_Charge);
				Short[month] += Long[month];
			}
		}//end of while
		int check[12];
		for (int z = 0; z < 12; z++)
		{
			check[z] = 0;
		}

		for (int k = 0; k <= maxMonth; k++)	//handle intermonth spread
		{
			if (Short[k] != 0)
			{
				for (int l = 0; l < k; l++)
				{
					check[l] = 0;
					if ((Long[l] > -(Short[k])) && (Short[k] != 0))	//as soon as a long and short exist for the same month make short 0 if possible
					{
						Long[l] += Short[k];
						DMSC += Short[k] * Spread_Charge;	//add to DMSC everytime there is a non zero short
						Short[k] = 0;
						check[l] = 1;
					}
					else
					{
						Long[l] = 0;
						DMSC += -(Long[l] * Spread_Charge);
						Short[k] += Long[l];
					}
				}
			}
		}//end of for

		for (int k = 0; k <= maxMonth; k++)	//find Delivery Month outright charge(DMOC)
		{
			if (check[k] == 1)
				DMOC += Long[k] * Outright_Charge;
		}
		DMC = DMOC - DMSC;	//DMSC is -ve so subtract to add abs values - Delivery Month Charge

	}//end of topmost if
	float maxPosLoss = posLoss[0], pairedPosLoss = 0, VASC, TimeRisk = 0, wFutPrRisk, ICSC = 0;	//declarations reqd for section 4
	for (int i = 0; i < 16; i++)
	{
		if (maxPosLoss > posLoss[i])
		{
			maxPosLoss = posLoss[i];
			if ((i % 2) == 0)
			{
				pairedPosLoss = posLoss[i + 1];
			}
			else
			{
				pairedPosLoss = posLoss[i - 1];
			}
		}

	}
	

	//start of calc for intercommodity spread credit
	
	VASC = -(maxPosLoss + pairedPosLoss) / 2;	
	TimeRisk = (posLoss[0] + posLoss[1]) / 2;
	wFutPrRisk = (VASC - TimeRisk) / netposdel;
	int PCS1 = Credit * -(CuNetPos) * wFutPrRisk;
	int PCS2 = Credit * -(CuNetPos)* CuWFPR;
	ICSC = PCS1 + PCS2;
	
	//end of calc for section 4

	//second part of calculations
	int tier[10], T, SpArray, count = 0, TSpreadArr[40], DSpreadArr[30], j = 0;
	while (!feof(readTDT))
	{
		count++;
		fscanf_s(readTDT, "%d\t", &T);
		fscanf_s(readTDT, "%d\n", &tier[T - 1]);
	}
	while (!feof(readTST))
	{
		int i, temp;
		fscanf_s(readTST, "%d\t", &temp);
		for (i = 0; i < count - 1; i++)
			fscanf_s(readTST, "%d\t", &TSpreadArr[j++]);	//read as 50,0,0,80,60,0,90,100,70
		fscanf_s(readTST, "%d\n", &TSpreadArr[j++]);
	}
	while (!feof(readDST))
	{
		int i = 0, temp;
		for (int i = 0; i < count; i++)
		{
			fscanf_s(readDST, "%d\t%d\t%d\n", &temp, &DSpreadArr[(2 * i)], &DSpreadArr[(2 * i) + 1]);	//store long0, short0, long1, short1..
		}
	}
	int TSC = 0;
	while (!feof(readSPT))
	{
		char col, row, ind;
		fscanf_s(readSPT, "%d %d\n", &col, &row);
		ind = (3 * (row - 1)) + col - 1 ;	//index for TSpreadArr
		col = (col - 1) * 2;
		row = (2 * row) - 1;	//convert row and col to corresponding indices in DSpreadArr
		if ((DSpreadArr[col] != 0) && (DSpreadArr[row] != 0))	//For eg, 1 to 3 will access 15 and -5 from DSpreadArr and 90 from TSpreadArr
		{
			TSC += DSpreadArr[row] * TSpreadArr[ind]; // calc TSC and Long - Short
			DSpreadArr[col] = (DSpreadArr[col] + DSpreadArr[row] >= 0) ? (DSpreadArr[col] + DSpreadArr[row]) : 0;	//assign diff only if Long > Short
			DSpreadArr[row] = (DSpreadArr[col] + DSpreadArr[row] >= 0) ? 0 : (DSpreadArr[row] + DSpreadArr[col]);	//assign diff only if Long > Short
		}
	}	//end of if


	//Beginning of Cross-commodity calculations
	int CrossOutCharge, CrossRatio, CrossComCharge = 0;
	int intrRate;
	int i = 0;
	if (!(fscanf_s(readInterRate, "%d", &intrRate)))
	{
		std::cout << "FILE READ ERROR" << endl;
	}
	while (!feof(readOC))
	{
		fscanf_s(readOC, "%d ", &CrossOutCharge);
		fscanf_s(readRatio, "%d ", &CrossRatio);
		CrossComCharge += CrossRatio * CrossOutCharge;
	}
	
	CrossComCharge = (float)CrossComCharge * (float)intrRate / 100.0;

	//std::cout << "\n  CrossCharge : " << CrossComCharge << endl;
	GetSystemTime(&end);
	//closing all opened files
	float InitMargReq = (-maxPosLoss) + (-TSC) + DMC - ICSC -CrossComCharge;	//Intitial Margin Requirement

	std::cout << endl << InitMargReq << endl;
	

	//closing all opened text files
	if (readPA)
	{ 
		fclose(readPA);
	}
	if (readPort)
	{
		fclose(readPort);
	}
	if (readRAr)
	{
		fclose(readRAr);
	}
	if (readTST)
	{
		fclose(readTST);
	}
	if (readDST)
	{
		fclose(readDST);
	}
	if (readSPT)
	{
		fclose(readSPT);
	}
	if (readTDT)
	{
		fclose(readTDT);
	}
	if (readOC)
	{
		fclose(readOC);
	}
	if (readRatio)
	{
		fclose(readRatio);
	}
	if (readInterRate)
	{
		fclose(readInterRate);
	}
	
	diff.wMinute = start.wMinute - end.wMinute;
	diff.wSecond = start.wSecond - end.wSecond;
	diff.wMilliseconds = start.wMilliseconds - end.wMilliseconds;	//Total program run time calculations
	std::cout << "\nTime Taken to complete program " << (end.wMilliseconds - start.wMilliseconds) << "milliseconds " << endl;
	_getch();
}